function [boundBARS] = GetBoundaryBars(BARS,NODE,ELEM)

Nn = max(max(BARS));
Nb = size(BARS,1);
Ne = length(ELEM);
NpE = cellfun(@numel,ELEM);

FACE = sparse([],[],[],Nn,Nn,sum(NpE));
for i=1:Ne
    myELEM = reshape(ELEM{i},1,numel(ELEM{i}));
    MyFACE = [myELEM; myELEM(2:end) myELEM(1)];
    for j=1:NpE(i)
        if FACE(MyFACE(1,j),MyFACE(2,j))==0 % New edge - Flag it
            FACE(MyFACE(1,j),MyFACE(2,j)) = i;
            FACE(MyFACE(2,j),MyFACE(1,j)) =-i;
        elseif isnan(FACE(MyFACE(1,j),MyFACE(2,j)))
            error(sprintf('Edge [%d %d] found in >2 elements',MyFACE(:,j)))
        else % Edge belongs to 2 elements: inside domain. Lock it.
            FACE(MyFACE(1,j),MyFACE(2,j)) = NaN;
            FACE(MyFACE(2,j),MyFACE(1,j)) = NaN;
        end
    end
end
[BOUND(:,1),BOUND(:,2)] = find(FACE>0);
% BOUND(:,3) = FACE(sub2ind(size(FACE),BOUND(:,1),BOUND(:,2))); %Get parent
ind = find(BOUND(:,1)>BOUND(:,2));
BOUND(ind,:) = fliplr(BOUND(ind,:));

A = sparse(BARS(:,1),BARS(:,2),(1:Nb)',Nn,Nn);
boundBARS = full(A(sub2ind(size(A),BOUND(:,1),BOUND(:,2))));
return